#ifdef GL_ES
precision mediump float;

varying float specular;
varying float diffuse;
varying vec2 vTexCoord;

vec4 fragColor;
#else
in float specular;
in float diffuse;
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform sampler2D colorTex;
uniform vec4 inColor;
uniform float percentage;

void main()
{
#ifdef GL_ES
	vec4 tColor = texture2D(colorTex, vTexCoord.st);
#else
    vec4 tColor = texture(colorTex, vTexCoord.st);
#endif
    
	fragColor = vec4(mix(tColor.rgb, inColor.rgb, percentage) * diffuse + vec3(specular * tColor.a), 1.0);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
